<?php

class Crossroads_PayEx_Model_Observer extends Mage_Core_Model_Abstract {
    protected $WHITELIST = ["shippingMethod", "paymentMethod", "agreements"];

    public function registerPayment(Varien_Event_Observer $observer) {
        $observer->getRegistry()->addMethod(new Crossroads_PayEx_Payment_Masterpass());
    }

    public function resetOrderRef(Varien_Event_Observer $observer) {
        $quote = $observer->getQuote();

        $quote->getPayment()->unsAdditionalInformation(self::FIELD_ORDER_REF, $orderRef);
        $quote->getPayment()->save();
        $quote->save();
    }

    public function cleanCheckoutParams(Varien_Event_Observer $observer) {
        $quote  = $observer->getQuote();
        $params = $observer->getParams();

        if($quote->getPayment()->getMethod() !== "crossroads_payex_masterpass") {
            return;
        }

        $newParams = [];

        foreach($this->WHITELIST as $k) {
            if($params->getData($k)) {
                $newParams[$k] = $params->getData($k);
            }
        }

        $params->setData($newParams);
    }
}
