<?php
class Crossroads_Partner_Block_Adminhtml_Partner_Edit_Form extends Mage_Adminhtml_Block_Widget_Form
{
    protected function _prepareForm() {
        // Instantiate a new form to display our partner for editing.
        $form = new Varien_Data_Form([
            'id' => 'edit_form',
            'action' => $this->getUrl(
                'adminhtml/partner_partner/edit',
                [
                    '_current' => true,
                    'continue' => 0,
                ]
            ),
            'method' => 'post',
            'enctype' => 'multipart/form-data'
        ]);
        $form->setUseContainer(true);
        $this->setForm($form);

        // Define a new fieldset. We need only one for our simple entity.
        $fieldset = $form->addFieldset('general',
            [
                'legend' => $this->__('Partner Details')
            ]
        );

        // Add the fields that we want to be editable.
        $this->_addFieldsToFieldset($fieldset, [
            'store_id' => [
                'input'    => 'multiselect',
                'name'     => 'stores[]',
                'label'    => Mage::helper('crossroads_partner')->__('Store View'),
                'title'    => Mage::helper('crossroads_partner')->__('Store View'),
                'required' => true,
                'values'   => Mage::getSingleton('adminhtml/system_store')->getStoreValuesForForm(false, true),
            ],
            'name' => [
                'label' => $this->__('Name'),
                'input' => 'text',
                'required' => true,
            ],
            'title' => [
                'label' => $this->__('Title'),
                'input' => 'text',
                'required' => true,
            ],
            'external_url' => [
                'label' => $this->__('External URL'),
                'input' => 'text',
                'required' => true,
            ],
            'call_to_action' => [
                'label' => $this->__('Call to action'),
                'input' => 'text',
                'required' => true,
            ],
            // todo: this should be a wysiwyg field
            'description' => [
                'label' => $this->__('Description'),
                'style'     => 'height:15em: width: 100%;',
                'config'    => Mage::getSingleton('cms/wysiwyg_config')->getConfig(),
                'input'     => 'editor',
                'wysiwyg'   => true,
                'required'  => false,
            ],
            'image' => [
                'label' => $this->__('Image'),
                'input' => 'image',
            ],
            'logotype' => [
                'label' => $this->__('Logotype'),
                'input' => 'image',
            ],
            'status' => [
                'label' => $this->__('Status'),
                'input' => 'select',
                'required' => true,
                'options' => Mage::getSingleton('crossroads_partner/partner')->getAvailableStatuses(),
            ]
        ]);

        return $this;
    }

    protected function _addFieldsToFieldset(Varien_Data_Form_Element_Fieldset $fieldset, $fields) {
        $requestData = new Varien_Object($this->getRequest()->getPost('partnerData'));

        foreach ($fields as $name => $_data) {
            if ($requestValue = $requestData->getData($name)) {
                $_data['value'] = $requestValue;
            }

            $_data['name'] = "partnerData[$name]";
            $_data['title'] = $_data['label'];

            // If no new value exists, use the existing partner data.
            if (!array_key_exists('value', $_data)) {
                $_data['value'] = $this->_getPartner()->getData($name);
            }

            $fieldset->addField($name, $_data['input'], $_data);
        }

        return $this;
    }

    /**
     * Retrieve the existing partner for pre-populating the form fields.
     * For a new partner entry, this will return an empty partner object.
     */
    protected function _getPartner() {
        if (!$this->hasData('partner')) {
            // This will have been set in the controller.
            $partner = Mage::registry('current_partner');

            // Just in case the controller does not register the partner.
            if (!$partner instanceof Crossroads_Partner_Model_Partner) {
                $partner = Mage::getModel('crossroads_partner/partner');
            }

            $this->setData('partner', $partner);
        }

        return $this->getData('partner');
    }
}
