<?php

$this->startSetup();

$table = new Varien_Db_Ddl_Table();

$table->setName($this->getTable('crossroads_partner/partner'));

$table->addColumn(
    'entity_id',
    Varien_Db_Ddl_Table::TYPE_INTEGER,
    10,
    [
        'auto_increment' => true,
        'unsigned' => true,
        'nullable'=> false,
        'primary' => true
    ]
);
$table->addColumn(
    'created_at',
    Varien_Db_Ddl_Table::TYPE_DATETIME,
    null,
    [
        'nullable' => false
    ]
);
$table->addColumn(
    'updated_at',
    Varien_Db_Ddl_Table::TYPE_DATETIME,
    null,
    [
        'nullable' => false
    ]
);
$table->addColumn(
    'name',
    Varien_Db_Ddl_Table::TYPE_VARCHAR,
    255,
    [
        'nullable' => true
    ]
);
$table->addColumn(
    'title',
    Varien_Db_Ddl_Table::TYPE_VARCHAR,
    255,
    [
        'nullable' => true
    ]
);
$table->addColumn(
    'slug',
    Varien_Db_Ddl_Table::TYPE_VARCHAR,
    255,
    [
        'nullable' => true
    ]
);
$table->addColumn(
    'external_url',
    Varien_Db_Ddl_Table::TYPE_VARCHAR,
    255,
    [
        'nullable' => true
    ]
);
$table->addColumn(
    'call_to_action',
    Varien_Db_Ddl_Table::TYPE_VARCHAR,
    255,
    [
        'nullable' => true
    ]
);
$table->addColumn(
    'description',
    Varien_Db_Ddl_Table::TYPE_TEXT,
    65535,
    [
        'nullable' => true
    ]
);
$table->addColumn(
    'logotype',
    Varien_Db_Ddl_Table::TYPE_TEXT,
    65535,
    [
        'nullable' => true
    ]
);
$table->addColumn(
    'image',
    Varien_Db_Ddl_Table::TYPE_TEXT,
    65535,
    [
        'nullable' => true
    ]
);
$table->addColumn(
    'status',
    Varien_Db_Ddl_Table::TYPE_BOOLEAN,
    null,
    [
        'nullable' => false
    ]
);
$table->addColumn(
    'store_id',
    Varien_Db_Ddl_Table::TYPE_VARCHAR,
    255,
    [
        'nullable' => true
    ]
);

$table->setOption('type', 'InnoDB');
$table->setOption('charset', 'utf8');


$this->getConnection()->createTable($table);

$this->endSetup();
