<?php
class Crossroads_Partner_PartnerController extends Crossroads_API_Controller_Resource
{
	/**
     * @api {get} /partner Fetch a list of all Partners
     * @apiName getPartners
     * @apiGroup Partner
     *
     * @apiSuccess {Integer} id
     * @apiSuccess {String} name
     * @apiSuccess {String} description
     * @apiSuccess {String} image
     * @apiSuccess {String} logotype
     * @apiSuccess {Object} callToAction
     * @apiSuccess {String} callToAction.url
     * @apiSuccess {String} callToAction.label
     */
    public function getAll() {
        $partners = Mage::helper('crossroads_partner')->getAll();

        return [200, $partners];
    }

    /**
     * @api {get} /partner/:id Request Partner page
     * @apiName getPartner
     * @apiGroup Partner
     *
     * @apiParam {Integer} id The ID of the partner
     * @apiSuccess {Integer} id
     * @apiSuccess {String} name
     * @apiSuccess {String} description
     * @apiSuccess {String} image
     * @apiSuccess {String} logotype
     * @apiSuccess {Object} callToAction
     * @apiSuccess {String} callToAction.url
     * @apiSuccess {String} callToAction.label
     *
     */
    public function getItem($id)
    {
        $partner = Mage::helper('crossroads_partner')->getItem($id);

        if (empty($partner)) {
            return [404];
        }

        return [200, $partner];
    }
}
