<?php
class Crossroads_Partner_Adminhtml_Partner_PartnerController extends Mage_Adminhtml_Controller_Action
{
    private function _uploadImage($files, $postData, $index) {
        if(isset($postData[$index]['delete']) && $postData[$index]['delete'] == 1) {
            // We're choosing to not delete the image from the hard drive
            // on purpose. I don't have time to add safety checks.
            $postData[$index] = '';
            return $postData;
        }
        if (isset($files['name'][$index]) && file_exists($files['tmp_name'][$index])) {
            $uploader = new Varien_File_Uploader(
                [
                    'name'     => $files['name'][$index],
                    'type'     => $files['type'][$index],
                    'tmp_name' => $files['tmp_name'][$index],
                    'error'    => $files['error'][$index],
                    'size'     => $files['size'][$index]
                ]);

            $uploader->setAllowedExtensions(['jpg','jpeg','gif','png']);
            $uploader->setAllowRenameFiles(false);
            $uploader->setFilesDispersion(false);

            $path = Mage::getBaseDir('media') . DS . 'partner' . DS;

            if (!is_dir($path)) {
                mkdir($path, 0777, true);
            }

            $uploader->save($path, $files['name'][$index]);

            $postData[$index] = 'partner' . DS . $files['name'][$index];
        } else {
            if(isset($postData['delete']) && $postData['delete'] == 1) {
                $postData[$index] = '';
            } else {
                unset($postData[$index]);
            }
        }
        return $postData;
    }
    /**
     * Instantiate our grid container block and add to the page content.
     * When accessing this admin index page, we will see a grid of all
     * partners currently available in our Magento instance, along with
     * a button to add a new one if we wish.
     */
    public function indexAction()
    {
        // instantiate the grid container
        $partnerBlock = $this->getLayout()
            ->createBlock('crossroads_partner_adminhtml/partner');

        // Add the grid container as the only item on this page
        $this->loadLayout()
            ->_addContent($partnerBlock)
            ->renderLayout();
    }

    /**
     * This action handles both viewing and editing existing partners.
     */
    public function editAction()
    {
        /**
         * Retrieve existing partner data if an ID was specified.
         * If not, we will have an empty partner entity ready to be populated.
         */
        $partner = Mage::getModel('crossroads_partner/partner');
        if ($partnerId = $this->getRequest()->getParam('id', false)) {
            $partner->load($partnerId);

            if ($partner->getId() < 1) {
                $this->_getSession()->addError($this->__('This partner no longer exists.'));
                return $this->_redirect(
                    'crossroads_partner_admin/partner/index'
                );
            }
        }

        // process $_POST data if the form was submitted
        if ($postData = $this->getRequest()->getPost('partnerData')) {
            try {
                // Save stores
                if (isset($postData['store_id'])) {
                    $postData['store_id'] = implode(",", $postData['store_id']);
                }

                //Upload images
                $postData = $this->_uploadImage($_FILES["partnerData"], $postData, "image");
                $postData = $this->_uploadImage($_FILES["partnerData"], $postData, "logotype");

                // echo "<pre>"; print_r($postData); print_r($_FILES["partnerData"]); echo "</pre>"; die();

                $partner->addData($postData);
                $partner->save();

                $this->_getSession()->addSuccess(
                    $this->__('The partner has been saved.')
                );

                // redirect to remove $_POST data from the request
                return $this->_redirect(
                    'adminhtml/partner_partner/edit',
                    array('id' => $partner->getId())
                );
            } catch (Exception $e) {
                Mage::logException($e);
                $this->_getSession()->addError($e->getMessage());
            }

            /**
             * If we get to here, then something went wrong. Continue to
             * render the page as before, the difference this time being
             * that the submitted $_POST data is available.
             */
        }


        // Make the current partner object available to blocks.
        Mage::register('current_partner', $partner);

        // Instantiate the form container.
        $partnerEditBlock = $this->getLayout()->createBlock(
            'crossroads_partner_adminhtml/partner_edit'
        );

        // Add the form container as the only item on this page.
        $this->loadLayout()->_addContent($partnerEditBlock);

        if (Mage::getSingleton('cms/wysiwyg_config')->isEnabled()) {
            $this->getLayout()->getBlock('head')->setCanLoadTinyMce(true);
        }

        $this->renderLayout();
    }

    public function deleteAction()
    {
        $partner = Mage::getModel('crossroads_partner/partner');

        if ($partnerId = $this->getRequest()->getParam('id', false)) {
            $partner->load($partnerId);
        }

        if ($partner->getId() < 1) {
            $this->_getSession()->addError($this->__('This partner no longer exists.'));
            return $this->_redirect(
                'adminhtml/partner_partner/index'
            );
        }

        try {
            $partner->delete();
            $this->_getSession()->addSuccess($this->__('The partner has been deleted.'));
        } catch (Exception $e) {
            Mage::logException($e);
            $this->_getSession()->addError($e->getMessage());
        }

        return $this->_redirect(
            'adminhtml/partner_partner/index/'
        );
    }

    protected function _isAllowed()
    {
        return Mage::getSingleton('admin/session')->isAllowed('crossroads_partner/partner');
    }
}
