<?php
class Crossroads_Partner_Model_Partner extends Mage_Core_Model_Abstract
{
    const STATUS_DISABLED = '0';
    const STATUS_ENABLED = '1';

    protected function _construct()
    {
        $this->_init('crossroads_partner/partner');
    }

    private function _slugify($input) {
        return urlencode($input);
    }

    public function getLogotypeWithPath()
    {
        $img = $this->getLogotype();
        return (empty($img)) ? null : Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_MEDIA) . DS . $img;
    }

    public function getImageWithPath()
    {
        $img = $this->getImage();
        return (empty($img)) ? null : Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_MEDIA) . DS . $img;
    }

    public function isActive() {
        return $this->status === STATUS_ENABLED;
    }

    /**
     * This method is used in the grid and form for populating the dropdown.
     */
    public function getAvailableStatuses()
    {
        return array(
            self::STATUS_DISABLED => Mage::helper('crossroads_partner')->__('Disabled'),
            self::STATUS_ENABLED => Mage::helper('crossroads_partner')->__('Enabled'),
        );
    }

    protected function _beforeSave()
    {
        parent::_beforeSave();

        /**
         * Perform some actions just before a partner is saved.
         */
        $this->_updateTimestamps();
        $this->_prepareUrlKey();

        return $this;
    }

    protected function _updateTimestamps()
    {
        $timestamp = now();

        /**
         * Set the last updated timestamp.
         */
        $this->setUpdatedAt($timestamp);

        /**
         * If we have a brand new object, set the created timestamp.
         */
        if ($this->isObjectNew()) {
            $this->setCreatedAt($timestamp);
        }

        return $this;
    }

    protected function _prepareUrlKey()
    {
        $slug = $this->_slugify($this->getName());
        $this->setSlug($slug);
        return $this;
    }
}
