<?php

class Crossroads_Partner_Helper_Data extends Mage_Core_Helper_Abstract
{
    public function getAll() {
    	$store_id = Mage::app()->getStore()->getStoreId();

        $partners = Mage::getModel("crossroads_partner/partner")
            ->getCollection()
            ->addStoreFilter($store_id)
            ->addFieldToFilter("status", "1");

        $images = [];
        $logotypes = [];
        foreach ($partners as $partner) {
            $images[$partner->getId()] = $partner->getImageWithPath();
            $logotypes[$partner->getId()] = $partner->getLogotypeWithPath();
        }

        return array_map(function($partner) use ($images, $logotypes) {
            $partner["image"]    = $images[$partner["entity_id"]];
            $partner["logotype"] = $logotypes[$partner["entity_id"]];
        	return $this->preparePartner($partner);
        }, $partners->getData());
    }

    public function getItem($id) {
    	$partner = Mage::getModel('crossroads_partner/partner')->load($id);

        if(!$id || !$partner->getId()) {
            return null;
        }

        return $this->preparePartner($partner);
    }

    public function preparePartner($partner) {
    	return [
            "id"           => (int)$partner["entity_id"],
            "name"         => $partner["name"],
            "title"        => $partner["title"],
            "urlKey"       => $partner["slug"],
            "description"  => $partner["description"],
            "image"        => $partner["image"],
            "logotype"     => $partner["logotype"],
            "callToAction" => [
                "url"   => $partner["external_url"],
                "label" => $partner["call_to_action"],
            ],
        ];
    }
}
