<?php

class Crossroads_MailLogger_Model_Core_Email_Template extends Mage_Core_Model_Email_Template
{
    public function send($email, $name = null, array $variables = array())
    {
        $core_read = Mage::getSingleton('core/resource')->getConnection('core_read');
        $core_write = Mage::getSingleton('core/resource')->getConnection('core_write');

        $return = FALSE;
        Mage::dispatchEvent('email_template_send_before', array('email' => $this, 'email_to' => $email, 'name' => $name, 'variables' => $variables));

        if(!$this->getDoNotSend()){
            $emails = array_values((array)$email);
            $names = is_array($name) ? $name : (array)$name;
            $names = array_values($names);
            foreach ($emails as $key => $email) {
                if (!isset($names[$key])) {
                    $names[$key] = substr($email, 0, strpos($email, '@'));
                }
            }

            $variables['email'] = reset($emails);
            $variables['name'] = reset($names);

            $text = $this->getProcessedTemplate($variables, true);
            $subject = $this->getProcessedTemplateSubject($variables);

            $sql = "INSERT INTO mail_log (name,email,subject,body,sent) VALUES (:name,:email,:subject,:body,:sent)";
            $data = array(
                'name' => $variables['name'],
                'email' => $variables['email'],
                'subject' => $subject,
                'body' => $text,
                'sent' => date("Y-m-d H:i:s")
            );
            $core_write->query($sql,$data);

            $return = parent::send($email, $name, $variables);

            $fileLogMessage = "from: {$this->getSenderName()} <{$this->getSenderEmail()}>, to: {$variables['name']} <{$variables['email']}>, subject: {$subject}";
            Mage::log($fileLogMessage, LOG_DEBUG, 'sas_mail_senders.log', true);
        }

        Mage::dispatchEvent('email_template_send_after', array('email' => $this, 'email_to' => $email, 'name' => $name, 'variables' => $variables));
        return $return;
    }
}