# Mail Logger module

Module providing logging for emails sent by Magento.

**NOTE:** Incompatible with MageMonkey Mandrill due to both attempting to override `core/email_template`.

## Requirements

* [Composer](https://getcomposer.org/download/)
* Magento 1.9

## Composer.json

Add the following to your `composer.json`:

```
{
	"name": "Your project name",
	"description": "Your project description",
	"require": {
		"MailLogger": "dev-master",
		"magento-hackathon/magento-composer-installer": "*"
	},
	"repositories": [
		{
			"type": "vcs",
			"url":  "git@groot.crossroads.se:modules/MailLogger.git"
		}
	],
	"extra": {
		"magento-root-dir":      ".",
		"auto-append-gitignore": true
	}
}
```

## Development

When this module is installed in a project Composer clones the git reposiotry into `vendor/MailLogger`. It will then create hard-links according to the `extra.map` specification inside of `composer.json` of the `MailLogger` package.

To modify and develop the `MailLogger` module, modify files inside of `vendor/MailLogger` instead of `app/code/local/Crossroads/MailLogger`. Then commit and push like normal inside of `vendor/MailLogger`.
