<?php

declare(strict_types=1);

use MageQL\Registry;
use MageQL\Schema\AbstractSchema;
use MageQL\Type\AbstractBuilder;

class RequestTestModel_Schema extends AbstractSchema {
    public function getTypeBuilder(string $typeName, Registry $registry): ?AbstractBuilder {
        return null;
    }

    public function getTypeFields(string $typeName, Registry $registry): array {
        switch($typeName) {
        case "Query":
            return [
                "testIt" => $this->field("String!", "Test field")
                    ->setResolver(function() {
                        return "The test string";
                    }),
            ];
        default:
            return [];
        }
    }
}
