<?php

declare(strict_types=1);

namespace MageQL\Type;

use GraphQL\Type\Definition\UnionType;
use GraphQL\Type\Definition\Type;
use MageQL\Registry;

class UnionBuilder extends AbstractBuilder {
    /**
     * @var Array<string>
     */
    protected $types = [];

    /**
     * @param Array<string> $types
     */
    public function __construct(string $description, array $types) {
        parent::__construct($description);

        $this->types = $types;
    }

    public function createInstance(
        Registry $registry,
        string $typeName
    ): Type {
        return new UnionType([
            "name" => $typeName,
            "description" => $this->description,
            "types" => function () use($registry) {
                $types = [];

                foreach($this->types as $name) {
                    $types[] = $registry->getType($name);
                }

                return $types;
            },
        ]);
    }
}
