<?php

declare(strict_types=1);

/**
 * @psalm-type Result self::SUCCESS|self::NOT_MODIFIED|self::ERROR_NOT_LOGGED_IN|self::ERROR_INVALID_ADDRESS_ID|self::ERROR_INVALID_ADDRESS
 * @extends MageQL_Core_Model_Customer_Result_Address_Abstract<Result>
 */
class MageQL_Core_Model_Customer_Result_Address_Update extends MageQL_Core_Model_Customer_Result_Address_Abstract {
    const SUCCESS = "success";
    const NOT_MODIFIED = "notModified";
    const ERROR_NOT_LOGGED_IN = "errorNotLoggedIn";
    const ERROR_INVALID_ADDRESS_ID = "errorInvalidAddressId";
    const ERROR_INVALID_ADDRESS = "errorInvalidAddress";

    /**
     * @var ?Mage_Customer_Model_Address_Abstract
     */
    protected $address = null;

    /**
     * @param Result $result
     */
    public function __construct(
        string $result,
        Mage_Customer_Model_Customer $customer = null,
        Mage_Customer_Model_Address_Abstract $address = null
    ) {
        parent::__construct($result, $customer);

        $this->address = $address;
    }

    public function getAddress(): ?Mage_Customer_Model_Address_Abstract {
        return $this->address;
    }
}
