<?php

declare(strict_types=1);

/**
 * @template T of string
 * @template-inherits MageQL_Core_Model_Customer_Result_Abstract<T>
 */
class MageQL_Core_Model_Customer_Result_Address_Abstract extends MageQL_Core_Model_Customer_Result_Abstract {
    /**
     * @var ?Mage_Customer_Model_Address_Abstract
     */
    protected $address = null;

    /**
     * @param T $result
     */
    public function __construct(
        string $result,
        Mage_Customer_Model_Customer $customer = null,
        Mage_Customer_Model_Address_Abstract $address = null
    ) {
        parent::__construct($result, $customer);

        $this->address = $address;
    }

    public function getAddress(): ?Mage_Customer_Model_Address_Abstract {
        return $this->address;
    }

    public function getValidationErrors(): ?array {
        if($this->address) {
            return MageQL_Core_Model_Address::resolveValidationErrors($this->address);
        }

        return [];
    }
}
