<?php

declare(strict_types=1);

namespace MageQL\Type;

use GraphQL\Type\Definition\ObjectType;
use GraphQL\Type\Definition\ResolveInfo;
use GraphQL\Type\Definition\Type;
use MageQL\Registry;

class ObjectBuilder extends AbstractBuilder {
    /**
     * @var Array<string>
     */
    protected $interfaces = [];
    /**
     * @var ?callable(mixed, array, mixed, ResolveInfo)
     */
    protected $resolveField = null;

    /**
     * @param Array<string> $interfaces
     */
    public function setInterfaces(array $interfaces): self {
        $this->interfaces = $interfaces;

        return $this;
    }

    /**
     * @return Array<string>
     */
    public function getInterfaces(): array {
        return $this->interfaces;
    }

    /**
     * @return ?callable(mixed, array, mixed, ResolveInfo)
     */
    public function getResolveFields(): ?callable {
        return $this->resolveField;
    }

    /**
     * @param callable(mixed, array, mixed, ResolveInfo) $resolver
     */
    public function setResolveField(callable $resolver): self {
        $this->resolveField = $resolver;

        return $this;
    }

    public function createInstance(
        Registry $registry,
        string $typeName
    ): Type {
        // TODO: isTypeOf
        return new ObjectType($this->getObjectSpec($registry, $typeName));
    }

    /**
     * @return array{description:string, fields:callable, interfaces:callable, name:string, resolveField:?callable}
     */
    protected function getObjectSpec(
        Registry $registry,
        string $typeName
    ): array {
        return [
            "name" => $typeName,
            "description" => $this->description,
            "resolveField" => $this->resolveField,
            "interfaces" => function () use($registry): array {
                $interfaces = [];

                foreach($this->interfaces as $name) {
                    $interfaces[] = $registry->getType($name);
                }

                return $interfaces;
            },
            "fields" => function() use($registry, $typeName): array {
                return $registry->getFields($typeName);
            },
        ];
    }
}
