<?php

declare(strict_types=1);

namespace MageQL\Type;

use MageQL\Registry;
use GraphQL\Type\Definition\Type;

abstract class TypedBuilder {
    /**
     * @var string
     */
    protected $description;
    /**
     * @var string
     */
    protected $type;

    public function __construct(string $typeName, string $description) {
        $this->type = $typeName;
        $this->description = $description;
    }

    public function getDescription(): ?string {
        return $this->description;
    }

    public function getType(): string {
        return $this->type;
    }

    /**
     * @return array{name:string, description:?string, type:?Type}
     */
    abstract function createInstance(
        Registry $registry,
        string $typeName
    ): array;
}
