<?php

declare(strict_types=1);

use GraphQL\Error\ClientAware;

class MageQL_Core_InvalidAttributeOptionException
    extends Exception
    implements ClientAware {
    public function __construct(string $fieldName, string $optionValue) {
        parent::__construct(sprintf(
            "Option '%s' is invalid for field '%s'.",
            $optionValue,
            $fieldName
        ));
    }

    public function isClientSafe() {
        return true;
    }

    public function getCategory() {
        return "mageql";
    }
}

