<?php

declare(strict_types=1);

use MageQL\ClientException;
use MageQL\Registry;
use MageQL\Schema\AbstractSchema;
use MageQL\Type\AbstractBuilder;

class ExceptionTestModel_Schema extends AbstractSchema {
    public function getTypeBuilder(string $typeName, Registry $registry): ?AbstractBuilder {
        return null;
    }

    public function getTypeFields(string $typeName, Registry $registry): array {
        switch($typeName) {
        case "Query":
            return [
                "somethingOdd" => $this->field("String!", "This crashes when resolved")
                    ->setResolver(function() {
                        throw new Exception("We failed!");
                    }),
                "clientException" => $this->field("String!", "This crashes with a client exception when resolved")
                    ->setResolver(function() {
                        throw new class extends ClientException {
                            public function __construct() {
                                parent::__construct("My Coded Exception");
                            }

                            public function isClientSafe() {
                                return true;
                            }

                            public function getCategory() {
                                return "exception_test";
                            }

                            public function getExtensions(): array {
                                return [
                                    "code" => "my_code",
                                ];
                            }
                        };
                    }),
                "complexField" => $this->field("[String!]!", "This has custom complexity")
                    ->addArgument("limit", $this->argument("Int!", "Number of results to return"))
                    ->setComplexity(function(int $unusedSrc, array $args): int {
                        $ownComplexity = 1;
                        return $ownComplexity * $args['limit'];
                    })
                    ->setResolver(function($unusedSrc, array $args) {
                        return array_slice([0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10], 0, $args['limit']);
                    }),
            ];
        default:
            return [];
        }
    }
}
