# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [6.4.5] - 2024-10-28
### Added
- support for validating queries against complexity before executing them

## [6.4.4] - 2024-08-22
### Removed
- **Backwards Incompatible** Content-types of `application/x-www-form-urlencoded`
  are no longer allowed due to security-issues related to bypass of
  Cross-Origin Resource Sharing (CORS).

## [6.4.3] - 2024-04-04
### Added
- Added store code

## [6.4.2] - 2024-01-16
### Fixed
- Ignore invalid datetimes when resolving datetimes.

## [6.4.1] - 2023-05-15
### Fixed
- Type of `MageQL\forwardResolver` now has a signature compatible with `setResolveField`.

## [6.4.0] - 2021-11-30
### Changed
- Proper `client_errors` exception logging including trace.

## [6.3.0] - 2021-11-17
### Added
- Debug logging of all `ClientAware.isClientSafe` exceptions.
- More exception logging in case of failure.
### Fixed
- `CustomerAddress`.`id` was not populated after createCustomerAddress mutation.
- Better support for multiselect attributes.
- Interfaces implementing interfaces no longer fail type-resolution.

## [6.2.0] - 2021-03-24
### Added
- Setting to disable updateCustomerEmail mutation.

## [6.1.4] - 2021-03-16
### Fixed
- `ClientException`s errors thrown outside of query-execution are now properly
  handled and their extensions values are propagated in the response.

## [6.1.3] - 2021-03-08
### Fixed
- Null description in dynamic attributes

## [6.1.2] - 2021-03-08
### Deprecated
- `AbstractSchema` class, implement `SchemaInterface` instead.
- `MageQL_Core_Model_Context`, use `MageQL\Context`.
### Removed
- `Crossroads_API_ResponseException` instance.
- `MageQL\Core\ContextInterface`
- `MageQL_Core_Model_Context::REGISTRY_KEY` and the corresponding registry storage.
### Fixed
- Input attribute option values are now mapped to their internal representation.

## [6.1.1] - 2021-02-02
### Fixed
- Types implementing interfaces failing schema validation. Temporarily load
  unreachable types (ie. types implementing interfaces) even in production.
  See: https://github.com/webonyx/graphql-php/issues/771

## [6.1.0] - 2021-02-02
### Added
- Function to sanitize GraphQL names.

## [6.0.1] - 2021-01-28
### Fixed
- Test customers are now properly confirmed.

## [6.0.0] - 2021-01-28
### Added
- Support for interfaces inheriting interfaces with `InterfaceBuilder`.`setInterfaces`.
- `MageQL\Core\Schema\SchemaInterface` interface.
### Changed
- Schemas can now either implement `MageQL\Core\Schema\SchemaInterface` or
  extend from `MageQL\Core\Schema\AbstractSchema`.
- Removed `MageQL_Core_Model_Schema_Abstract`.`context` property.
### Deprecated
- `MageQL_Core_Model_Schema_Abstract` class, use `MageQL\Schema\AbstractSchema` instead.

## [5.0.3] - 2020-11-02
### Fixed
- Type-error when copying attribute data.

## [5.0.2] - 2020-11-02
### Fixed
- Address attributes with underscore in the attribute code are now properly written.

## [5.0.1] - 2020-10-29
### Changed
- Base Address fields on Customer Address

## [5.0.0] - 2020-10-29
### Added
- Support for custom attributes in `CustomerAddressInput`.
- Support for custom attributes in `UpdateCustomerInput`.
- Internal API for copying fields based on attributes.
### Changed
- `AddressInput` renamed to `CustomerAddressInput`.

## [4.3.1] - 2020-10-27
### Fixed
- Interface mismatch between `Address` and `CustomerAddress` type.

## [4.3.0] - 2020-10-27
### Added
- `subscribeToNewsletter` mutation which subscribes a customer or a supplied
  email to the newsletter.

## [4.2.1] - 2020-10-27
### Fixed
- Crash when using older PHP version.

## [4.2.0] - 2020-10-26
### Changed
- `CustomerAddress` fields are now loaded dynamically based on attributes.

## [4.1.1] - 2020-09-18
### Fixed
- Events `mageql_core_mutation_createCustomerAddress_success` and
  `mageql_core_mutation_updateCustomerAddress_success` now contain the actual
  customer object in the customer property.

## [4.1.0] - 2020-09-03
### Added
- Non `default` schema will now have `Query` and `Mutation` types provided.

## [4.0.0] - 2020-08-31
### Changed
- Updated to webonyx/graphql-php version 14.3.0.
- Updated to openmage/magento-lts version 20.

## [3.2.1] - 2020-06-29
### Fixed
- Type-fixes

## [3.2.0] - 2020-06-29
### Added
- `ClientException` with an overridable method which adds key-values to the
  graphql error `extensions` map.

## [3.1.8] - 2020-06-25
### Changed
- Downgraded webonyx/graphql-php to 0.13, waiting on https://github.com/webonyx/graphql-php/pull/679.

## [3.1.7] - 2020-06-23
### Changed
- Updated to webonyx/graphql-php version 14.

## [3.1.6] - 2020-06-12
### Fixed
- Ensure HTTPOnly is enabled by default for cookies.

## [3.1.5] - 2020-06-12
### Fixed
- Respect the store id when loading CMS pages in `route`-resolver.

## [3.1.4] - 2020-06-04
### Fixed
- Added forced validation to `MageQL_Core_Model_Address::setCommonFields`
  preventing invalid country codes from being saved. A `ClientAware` and client
  safe exception will be thrown if an invalid country code is supplied.

## [3.1.3] - 2020-06-03
### Fixed
- GraphQL Playground now uses an endpoint without trailing slash.

## [3.1.2] - 2020-06-02
### Fixed
- GraphQL Playground did not start properly.

## [3.1.1] - 2020-06-02
### Changed
- GraphiQL has been replaced with GraphQL Playground.

## [3.1.0] - 2020-06-01
### Added
- `mageql_core_context_after` event triggered once the execution context is
  created, before the schema is created or queries/mutations are executed.
### Changed
- Module source code is no longer installed in Magento to prevent duplicates
  in autoloading.
- Upgraded crossroads/testing-magento to crossroads/magento-testing-library,
  using openmage/magento-lts for testing.

## [3.0.3] - 2020-05-22
### Changed
- Tests are now located in `test/core`.
- Static analysis is now also run on tests.

## [3.0.2] - 2020-05-20
### Changed
- Tests are now split in parts to allow dependent modules to run core-tests.

## [3.0.1] - 2020-05-19
### Added
- Proper schema test

## [3.0.0] - 2020-05-19
### Added
- `mageql_core_mutation_updateCustomer_success` event triggered when the
  `updateCustomer` mutation is successful.
- `mageql_core_mutation_updateCustomerEmail_success` event triggered when when
  the `updateCustomerEmail` mutation is successful.
- `mageql_core_mutation_setCustomerDefaultAddress_success` event triggered when
  the `setCustomerDefaultBillingAddress` or `setCustomerDefaultShippingAddress`
  mutations are successful.
- `mageql_core_mutation_createCustomerAddress_success` event triggered when the
  `createCustomerAddress` mutation is successful.
- `mageql_core_mutation_updateCustomerAddress_success` event triggered when the
  `updateCustomerAddress` mutation is successful.
### Changed
- Dropped support for PHP 7.2 and 7.3.
### Fixed
- `setDefaultBillingAddress` and `setDefaultShippingAddress` mutations now
  respond with `"notModified"` when the client attempts to set the default
  address to the existing default address.

## [2.2.0] - 2020-04-08
### Added
- New `updateCustomer` mutation to update customer attributes.
- `loginCustomer` mutation can now be disabled through Magento Admin Configuration.
### Fixed
- `Customer`.`addresses` field is now non-nullable.

## [2.1.1] - 2020-03-12
### Changed
- Exclude federation SDL query in the returned SDL to avoid collisions.

## [2.1.0] - 2020-03-02
### Added
- Basic support for Federation spec through `_service` query.

## [2.0.0] - 2020-02-10
### Added
- Customer `addresses` field with list of customer addresses.
- Customer mutation for removing address.
- Customer mutations for default addresses.
- Customer mutation for updating addresses.
- Customer mutation for adding addresses.
### Changed
- Image attributes now result in `ImageData` object type, with the image URL
  on the `src` field.

## [1.1.3] - 2019-12-11
### Fixed
- Crash when running fixtures on an already initialized database.

## [1.1.2] - 2019-12-11
### Fixed
- Address being added to fixture customer.

## [1.1.1] - 2019-12-05
### Changed
- Updated GraphiQL to 0.17.2.

## [1.1.0] - 2019-12-03
### Added
- Event `mageql_core_route_resolve` enabling modules to short-circuit the
  rewrite-loading, resulting in a 404, if the target resource is not found.

## [1.0.8] - 2019-11-22
### Fixed
- Type-errors revealed by Psalm 3.6.0-ish.

## [1.0.7] - 2019-11-21
### Added
- `defaultMethodResolver` which calls getters on the source object to resolve.

## [1.0.6] - 2019-08-28
### Added
- The global instance of `MageQL_Core_Model_Context` for the current request is now
  registered at `MageQL_Core_Model_Context::REGISTRY_KEY`.

## [1.0.5] - 2019-08-27
### Changed
- More template parameters to `MageQL_Core_Model_Attributes_Abstract`.
- The `Price` type now has an extendable base class for different types.

## [1.0.4] - 2019-08-26
### Changed
- `loginCustomer` mutation error `"invalidEmailOrPassword"`
  is renamed to `"errorInvalidEmailOrPassword"`.
- `loginCustomer` mutation error `"notConfirmed"`
  is renamed to `"errorUserNotConfirmed"`.
- `MageQL\Type\InterfaceBuilder` `setResolveType` is renamed to
  `setTypeResolver` to avoid conflicts in naming with resolvers.

## [1.0.3] - 2019-08-22
### Added
- Added `updateCustomerEmail` mutation, this will also propagate to quote if a
  quote has been created.
### Fixed
- Fixed loading of backwards-compatible `Crossroads_API_ResponseException`.

## [1.0.2] - 2019-08-22
### Added
- Configuration for log files will now automatically activate `system.log` and
  `exception.log` when module is installed.
- Added `Crossroads_API_ResponseException` copy as a fallback in case
  `Crossroads_API` is not installed for compatibility with older modules.

## [1.0.1] - 2019-08-16
### Changed
- Updated package dependencies to reference actual versions.

## [1.0.0] - 2019-08-16
### Added
- Initial release.