<?php

declare(strict_types=1);

namespace MageQL\Type;

use GraphQL\Type\Definition\InterfaceType;
use MageQL\Registry;

class InterfaceBuilder extends AbstractBuilder {
    /**
     * @var Array<string>
     */
    protected $interfaces = [];
    /**
     * @var ?(callable(mixed): ?string)
     */
    protected $typeResolver;

    /**
     * @param Array<string> $interfaces
     */
    public function setInterfaces(array $interfaces): self {
        $this->interfaces = $interfaces;

        return $this;
    }

    /**
     * @return Array<string>
     */
    public function getInterfaces(): array {
        return $this->interfaces;
    }

    /**
     * @param (callable(mixed): ?string) $typeResolver
     */
    public function setTypeResolver(callable $typeResolver): self {
        $this->typeResolver = $typeResolver;

        return $this;
    }

    public function getTypeResolver(): ?callable {
        return $this->typeResolver;
    }

    public function createInstance(Registry $registry) {
        $data = [
            "description" => $this->description,
            "resolveType" => $this->typeResolver,
            "interfaces" => function () use($registry): array {
                $interfaces = [];

                foreach($this->interfaces as $name) {
                    $interfaces[] = $registry->getType($name);
                }

                return $interfaces;
            },
            "fields" => function() use($registry): array {
                if($this->name) {
                    return $registry->getFields($this->name);
                }

                return [];
            },
        ];

        if($this->name !== null) {
            $data["name"] = $this->name;
        }

        return new InterfaceType($data);
    }
}
