<?php

declare(strict_types=1);

namespace MageQL\Type;

use GraphQL\Type\Definition\UnionType;

use MageQL\Registry;

class UnionBuilder extends AbstractBuilder {
    /**
     * @var Array<string>
     */
    protected $types = [];

    public function __construct(array $params = []) {
        parent::__construct($params);

        $this->types = $params["types"];
    }

    public function createInstance(Registry $registry) {
        return new UnionType([
            "name" => $this->name,
            "description" => $this->description,
            "types" => function () use($registry) {
                $types = [];

                foreach($this->types as $name) {
                    $types[] = $registry->getType($name);
                }

                return $types;
            },
        ]);
    }
}
