<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

use MageQL\Type\AbstractBuilder;
use MageQL\Registry;

class MageQL_Core_Model_Schema_Newsletter extends MageQL_Core_Model_Schema_Abstract {
    public function getTypeBuilder(string $typeName, Registry $registry): ?AbstractBuilder {
        switch($typeName) {
        case "SubscribeToNewsletterResult":
            return $this->object("Type containing the result of subscribing to newsletters")
                ->setResolveField("MageQL\\defaultMethodResolver");

        case "SubscribeToNewslettersResultType":
            return $this->enum("Type of result from subscribeToNewsletter mutation", [
                MageQL_Core_Model_Customer_Result_Newsletter::SUCCESS => [
                    "description" => "Email was successfully subcribed.",
                ],
                MageQL_Core_Model_Customer_Result_Newsletter::NOT_MODIFIED => [
                    "description" => "Subscription not modified.",
                ],
                MageQL_Core_Model_Customer_Result_Newsletter::ERROR_INVALID_EMAIL => [
                    "description" => "Invalid email.",
                ],
                MageQL_Core_Model_Customer_Result_Newsletter::ERROR_NOT_LOGGED_IN => [
                    "description" => "Customer not logged in.",
                ],
            ]);

        default:
            return null;
        }
    }

    public function getTypeFields(string $typeName, Registry $registry): array {
        switch($typeName) {
        case "Mutation":
            return [
                "subscribeToNewsletter" => $this->field("SubscribeToNewsletterResult!", "Attempts to subscribe to newsletter")
                    ->addArgument("email", $this->argument("String", "The subscriber email"))
                    ->setResolver("MageQL_Core_Model_Customer::mutateSubsribeToNewsletter"),
            ];

        case "SubscribeToNewsletterResult":
            return [
                "result" => $this->field("SubscribeToNewslettersResultType!", "The type of result")
            ];

        default:
            return [];
        }
    }
}
