<?php

/**
 * Duplicate of Crossroads_API for compatibility with older modules.
 *
 * An exception used to raise errors communicated to the client using HTTP responses, unlike normal
 * exceptions this exception is not a system error.
 */
class Crossroads_API_ResponseException extends RuntimeException {
    /**
     * HTTP status code
     *
     * @var int
     */
    protected $statusCode = 400;

    /**
     * Extra data to supply in the error.
     *
     * @var mixed
     */
    protected $data = null;

    /**
     * Creates a new ResponseException with the given HTTP status-code, message, error-data, error-code and parent
     * exception.
     *
     * @param int $httpStatusCode
     * @param string $message
     * @param mixed $data
     * @param int $error_code
     * @param Exception $previous
     * @return Exception
     */
    public static function create($httpStatusCode, $message, $data = null, $error_code = null, $previous = null) {
        $ex = new Crossroads_API_ResponseException($message, $error_code ?: 0, $previous);

        $ex->_setStatusCode($httpStatusCode);
        $ex->_setData($data);

        return $ex;
    }

    /**
     * Sets the HTTP status code for this response, internal.
     *
     * @param mixed $statusCode
     * @return void
     */
    public function _setStatusCode($statusCode) {
        $this->statusCode = $statusCode;
    }

    /**
     * Returns the HTTP status code for this error response.
     *
     * @return int
     */
    public function getStatusCode() {
        return $this->statusCode;
    }

    /**
     * Sets the error data for this response, internal.
     *
     * @param mixed $data
     * @return void
     */
    public function _setData($data) {
        $this->data = $data;
    }

    /**
     * Returns the error-data to show in the response.
     *
     * @return mixed
     */
    public function getData() {
        return $this->data;
    }
}
