<?php

declare(strict_types=1);

/**
 * Added methods for querying fields and attributes by set.
 *
 * @template Item of Varien_Object
 * @template AttrData of array{
 *   code:string,
 *   backend_type:string,
 *   input:string,
 *   label:string,
 *   required:bool,
 *   not_system:bool,
 *   attribute_set:Array<string>,
 *   attribute_set_type:Array<string>
 * }
 *
 * @template-extends MageQL_Core_Model_Attributes_Abstract<Item, AttrData>
 */
abstract class MageQL_Core_Model_Attributes_Base extends MageQL_Core_Model_Attributes_Abstract {
    /**
     * @return Array<string, AttrData>
     */
    public function getSystemAttributes(): array {
        return array_filter($this->getAttributes(), function(array $a) {
            return ! $a["not_system"];
        });
    }

    /**
     * @return Array<string, AttrData>
     */
    public function getSetAttributes(string $attributeSetType): array {
        return array_filter($this->getAttributes(), function(array $a) use($attributeSetType) {
            return ! $a["not_system"] || in_array($attributeSetType, $a["attribute_set_type"]);
        });
    }
}
