<?php

declare(strict_types=1);

namespace MageQL\Type;

abstract class TypedBuilder extends AbstractBuilder {
    /**
     * @param string
     */
    protected $type;

    public function __construct(array $params = []) {
        $this->type = $params["type"];

        parent::__construct($params);
    }

    public function setType(string $type): self {
        $this->type = $type;

        return $this;
    }

    public function getType(): string {
        return $this->type;
    }
}
