<?php

declare(strict_types=1);

class MageQL_Core_Model_Route_Redirect extends Mage_Core_Model_Abstract {
    public static function resolveIsPermanent(Mage_Core_Model_Url_Rewrite $src): bool {
        return stripos($src->getOptions(), "P") !== false;
    }

    public static function resolveType(): string {
        return "redirect";
    }

    public static function resolveUrl(Mage_Core_Model_Url_Rewrite $src): string {
        $url = $src->getTargetPath();

        // Allow external redirects
        if(strpos($url, "https://") === 0 || strpos($url, "http://") === 0) {
            return $url;
        }

        // Always provide the root
        return "/".$url;
    }
}
