# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [4.0.0] - 2020-08-31
### Changed
- Updated to webonyx/graphql-php version 14.3.0.
- Updated to openmage/magento-lts version 20.

## [3.2.1] - 2020-06-29
### Fixed
- Type-fixes

## [3.2.0] - 2020-06-29
### Added
- `ClientException` with an overridable method which adds key-values to the
  graphql error `extensions` map.

## [3.1.8] - 2020-06-25
### Changed
- Downgraded webonyx/graphql-php to 0.13, waiting on https://github.com/webonyx/graphql-php/pull/679.

## [3.1.7] - 2020-06-23
### Changed
- Updated to webonyx/graphql-php version 14.

## [3.1.6] - 2020-06-12
### Fixed
- Ensure HTTPOnly is enabled by default for cookies.

## [3.1.5] - 2020-06-12
### Fixed
- Respect the store id when loading CMS pages in `route`-resolver.

## [3.1.4] - 2020-06-04
### Fixed
- Added forced validation to `MageQL_Core_Model_Address::setCommonFields`
  preventing invalid country codes from being saved. A `ClientAware` and client
  safe exception will be thrown if an invalid country code is supplied.

## [3.1.3] - 2020-06-03
### Fixed
- GraphQL Playground now uses an endpoint without trailing slash.

## [3.1.2] - 2020-06-02
### Fixed
- GraphQL Playground did not start properly.

## [3.1.1] - 2020-06-02
### Changed
- GraphiQL has been replaced with GraphQL Playground.

## [3.1.0] - 2020-06-01
### Added
- `mageql_core_context_after` event triggered once the execution context is
  created, before the schema is created or queries/mutations are executed.
### Changed
- Module source code is no longer installed in Magento to prevent duplicates
  in autoloading.
- Upgraded crossroads/testing-magento to crossroads/magento-testing-library,
  using openmage/magento-lts for testing.

## [3.0.3] - 2020-05-22
### Changed
- Tests are now located in `test/core`.
- Static analysis is now also run on tests.

## [3.0.2] - 2020-05-20
### Changed
- Tests are now split in parts to allow dependent modules to run core-tests.

## [3.0.1] - 2020-05-19
### Added
- Proper schema test

## [3.0.0] - 2020-05-19
### Added
- `mageql_core_mutation_updateCustomer_success` event triggered when the
  `updateCustomer` mutation is successful.
- `mageql_core_mutation_updateCustomerEmail_success` event triggered when when
  the `updateCustomerEmail` mutation is successful.
- `mageql_core_mutation_setCustomerDefaultAddress_success` event triggered when
  the `setCustomerDefaultBillingAddress` or `setCustomerDefaultShippingAddress`
  mutations are successful.
- `mageql_core_mutation_createCustomerAddress_success` event triggered when the
  `createCustomerAddress` mutation is successful.
- `mageql_core_mutation_updateCustomerAddress_success` event triggered when the
  `updateCustomerAddress` mutation is successful.
### Changed
- Dropped support for PHP 7.2 and 7.3.
### Fixed
- `setDefaultBillingAddress` and `setDefaultShippingAddress` mutations now
  respond with `"notModified"` when the client attempts to set the default
  address to the existing default address.

## [2.2.0] - 2020-04-08
### Added
- New `updateCustomer` mutation to update customer attributes.
- `loginCustomer` mutation can now be disabled through Magento Admin Configuration.
### Fixed
- `Customer`.`addresses` field is now non-nullable.

## [2.1.1] - 2020-03-12
### Changed
- Exclude federation SDL query in the returned SDL to avoid collisions.

## [2.1.0] - 2020-03-02
### Added
- Basic support for Federation spec through `_service` query.

## [2.0.0] - 2020-02-10
### Added
- Customer `addresses` field with list of customer addresses.
- Customer mutation for removing address.
- Customer mutations for default addresses.
- Customer mutation for updating addresses.
- Customer mutation for adding addresses.
### Changed
- Image attributes now result in `ImageData` object type, with the image URL
  on the `src` field.

## [1.1.3] - 2019-12-11
### Fixed
- Crash when running fixtures on an already initialized database.

## [1.1.2] - 2019-12-11
### Fixed
- Address being added to fixture customer.

## [1.1.1] - 2019-12-05
### Changed
- Updated GraphiQL to 0.17.2.

## [1.1.0] - 2019-12-03
### Added
- Event `mageql_core_route_resolve` enabling modules to short-circuit the
  rewrite-loading, resulting in a 404, if the target resource is not found.

## [1.0.8] - 2019-11-22
### Fixed
- Type-errors revealed by Psalm 3.6.0-ish.

## [1.0.7] - 2019-11-21
### Added
- `defaultMethodResolver` which calls getters on the source object to resolve.

## [1.0.6] - 2019-08-28
### Added
- The global instance of `MageQL_Core_Model_Context` for the current request is now
  registered at `MageQL_Core_Model_Context::REGISTRY_KEY`.

## [1.0.5] - 2019-08-27
### Changed
- More template parameters to `MageQL_Core_Model_Attributes_Abstract`.
- The `Price` type now has an extendable base class for different types.

## [1.0.4] - 2019-08-26
### Changed
- `loginCustomer` mutation error `"invalidEmailOrPassword"`
  is renamed to `"errorInvalidEmailOrPassword"`.
- `loginCustomer` mutation error `"notConfirmed"`
  is renamed to `"errorUserNotConfirmed"`.
- `MageQL\Type\InterfaceBuilder` `setResolveType` is renamed to
  `setTypeResolver` to avoid conflicts in naming with resolvers.

## [1.0.3] - 2019-08-22
### Added
- Added `updateCustomerEmail` mutation, this will also propagate to quote if a
  quote has been created.
### Fixed
- Fixed loading of backwards-compatible `Crossroads_API_ResponseException`.

## [1.0.2] - 2019-08-22
### Added
- Configuration for log files will now automatically activate `system.log` and
  `exception.log` when module is installed.
- Added `Crossroads_API_ResponseException` copy as a fallback in case
  `Crossroads_API` is not installed for compatibility with older modules.

## [1.0.1] - 2019-08-16
### Changed
- Updated package dependencies to reference actual versions.

## [1.0.0] - 2019-08-16
### Added
- Initial release.