<?php

declare(strict_types=1);

namespace MageQL;

class InactiveStoreException extends ClientException {
    public function __construct() {
        parent::__construct("Magento store is inactive.");
    }

    public function isClientSafe() {
        return false;
    }

    public function getCategory() {
        return "internal";
    }

    public function getExtensions(): array {
        return [
            "code" => "store_inactive",
        ];
    }
}

