<?php

declare(strict_types=1);

use MageQL\Registry;
use MageQL\Type\AbstractBuilder;

class ExceptionTestModel_Schema extends MageQL_Core_Model_Schema_Abstract {
    public function getTypeBuilder(string $typeName, Registry $registry): ?AbstractBuilder {
        return null;
    }

    public function getTypeFields(string $typeName, Registry $registry): array {
        switch($typeName) {
        case "Query":
            return [
                "somethingOdd" => $this->field("String!", "This crashes when resolved")
                    ->setResolver(function() {
                        throw new Exception("We failed!");
                    }),
            ];
        default:
            return [];
        }
    }
}
