<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

/**
 * @template-extends MageQL_Core_Model_Attributes_Customer_Abstract<Mage_Customer_Model_Customer>
 */
class MageQL_Core_Model_Attributes_Customer extends MageQL_Core_Model_Attributes_Customer_Abstract {
    protected function getEntityType(): string {
        return "customer";
    }

    public function getBaseAttributes(): array {
        return [
            "confirmation",
            "email",
        ];
    }

    public function getFieldAttributeMap(): array {
        return [
        ];
    }

    public function createImageWrapper(
        $src,
        MageQL_Core_Model_Context $ctx,
        ResolveInfo $info,
        string $attrCode,
        string $value
    ): MageQL_Core_Model_Attributes_Image_Abstract {
        throw new Exception(sprintf("%s: Not implemented", __METHOD__));
    }
}
