<?php

declare(strict_types=1);

namespace MageQL\Type;

use GraphQL\Type\Definition\InterfaceType;
use MageQL\Registry;

class InterfaceBuilder extends AbstractBuilder {
    /**
     * @var ?(callable(mixed): ?string)
     */
    protected $typeResolver;

    /**
     * @param (callable(mixed): ?string) $typeResolver
     */
    public function setTypeResolver(callable $typeResolver): self {
        $this->typeResolver = $typeResolver;

        return $this;
    }

    public function getTypeResolver(): ?callable {
        return $this->typeResolver;
    }

    public function createInstance(Registry $registry) {
        $data = [
            "description" => $this->description,
            "resolveType" => $this->typeResolver,
            "fields" => function() use($registry): array {
                if($this->name) {
                    return $registry->getFields($this->name);
                }

                return [];
            },
        ];

        if($this->name !== null) {
            $data["name"] = $this->name;
        }

        return new InterfaceType($data);
    }
}
