<?php

declare(strict_types=1);

/**
 * @psalm-type AttrData array{
 *   code:string,
 *   backend_type:string,
 *   input:string,
 *   label:string,
 *   required:bool,
 *   not_system:bool,
 *   attribute_set:Array<string>,
 *   attribute_set_type:Array<string>
 * }
 * @template Item of Varien_Object
 * @template-extends MageQL_Core_Model_Attributes_Base<Item, AttrData>
 */
abstract class MageQL_Core_Model_Attributes_Customer_Abstract extends MageQL_Core_Model_Attributes_Base {
    // Join more data on this since customer has additional data, only show is_visible
    protected function loadAttributes(): array {
        $db = Mage::getSingleton("core/resource")->getConnection("core_read");

        return $db->query(
"SELECT a.attribute_code code,
    a.backend_type,
    a.frontend_input input,
    a.frontend_label label,
    a.is_required required,
    a.is_user_defined not_system,
    COALESCE(GROUP_CONCAT(DISTINCT s.attribute_set_name SEPARATOR ','), '') attribute_set
FROM eav_attribute a
JOIN eav_entity_type t ON t.entity_type_id = a.entity_type_id
JOIN customer_eav_attribute c ON c.attribute_id = a.attribute_id
JOIN eav_entity_attribute e ON e.attribute_id = a.attribute_id
JOIN eav_attribute_set s ON s.attribute_set_id = e.attribute_set_id
WHERE t.entity_type_code = ?
  AND a.backend_type <> 'static'
  AND c.is_visible = 1
GROUP BY a.attribute_id
ORDER BY a.attribute_code ASC", [$this->getEntityType()])->fetchAll();
    }
}
