<?php

declare(strict_types=1);

namespace MageQL\Type;

use function array_key_exists;

use MageQL\Registry;

abstract class AbstractBuilder {
    /**
     * @var ?string
     */
    protected $name = null;
    /**
     * @var ?string
     */
    protected $description = null;

    public function __construct(array $params = []) {
        if(array_key_exists("name", $params)) {
            $this->name = $params["name"];
        }

        if(array_key_exists("description", $params)) {
            $this->description = $params["description"];
        }
    }

    public function setName(string $name): self {
        $this->name = $name;

        return $this;
    }

    public function getName(): ?string {
        return $this->name;
    }

    public function setDescription(string $description): self {
        $this->description = $description;

        return $this;
    }

    public function getDescription(): ?string {
        return $this->description;
    }

    /**
     * @return mixed
     */
    abstract public function createInstance(Registry $registry);
}
