<?php

declare(strict_types=1);

namespace MageQL\Type;

use GraphQL\Type\Definition\Type;
use GraphQL\Type\Definition\InputObjectType;

use MageQL\Registry;

class InputObjectBuilder extends ObjectBuilder {
    /**
     * @return InputObjectType
     */
    public function createInstance(Registry $registry) {
        $data = [
            "description" => $this->description,
            /**
             * @return Array<Type>
             */
            "interfaces" => function() use($registry): array {
                $interfaces = [];

                foreach($this->interfaces as $name) {
                    $interfaces[] = $registry->getType($name);
                }

                return $interfaces;
            },
            "fields" => function() use($registry): array {
                if($this->name) {
                    return $registry->getFields($this->name);
                }

                return [];
            },
        ];

        if($this->name !== null) {
            $data["name"] = $this->name;
        }

        return new InputObjectType($data);
    }
}
