<?php

declare(strict_types=1);

namespace MageQL\Type;

use GraphQL\Type\Definition\ResolveInfo;

use MageQL\Registry;

class FieldBuilder extends TypedBuilder {
    /**
     * @var ?(callable(mixed, array, mixed, ResolveInfo): mixed)
     */
    protected $resolver = null;
    /**
     * @var Array<string, ArgumentBuilder>
     */
    protected $arguments = [];
    /**
     * @var ?string
     */
    protected $deprecationReason = null;

    // TODO: Rework parameters
    public function __construct(array $params = []) {
        if(array_key_exists("resolver", $params)) {
            $this->resolver = $params["resolver"];
        }

        parent::__construct($params);
    }

    /**
     * @param (callable(mixed, array, mixed, ResolveInfo): mixed) $resolver
     */
    public function setResolver(callable $resolver): self {
        $this->resolver = $resolver;

        return $this;
    }

    /**
     * @return (callable(mixed, array, mixed, ResolveInfo): mixed)
     */
    public function getResolver(): ?callable {
        return $this->resolver;
    }

    /**
     * Deprecates this field with a reason.
     */
    public function setDeprecated(string $reason): self {
        $this->deprecationReason = $reason;

        return $this;
    }

    public function addArgument(string $name, ArgumentBuilder $arg): self {
        $this->arguments[$name] = $arg;

        return $this;
    }

    public function createInstance(Registry $registry) {
        $data = [
            "type" => $registry->getType($this->type),
            // FIXME: Return type
            "args" => array_map(function(ArgumentBuilder $arg) use($registry): array {
                return $arg->createInstance($registry);
            }, $this->arguments),
            "resolve" => $this->resolver,
            "description" => $this->description,
            "isDeprecated" => (boolean)$this->deprecationReason,
            "deprecationReason" => $this->deprecationReason,
        ];

        if($this->name !== null) {
            $data["name"] = $this->name;
        }

        return $data;
    }
}
