<?php

declare(strict_types=1);

namespace MageQL\Type;

use MageQL\Registry;

/**
 * @template T
 */
class ArgumentBuilder extends TypedBuilder {
    /**
     * @var ?T
     */
    protected $defaultValue = null;

    public function __construct(array $params = []) {
        if(array_key_exists("defaultValue", $params)) {
            $this->defaultValue = $params["defaultValue"];
        }

        parent::__construct($params);
    }

    /**
     * @param T $default
     */
    public function setDefaultValue($default): self {
        $this->defaultValue = $default;

        return $this;
    }

    public function createInstance(Registry $registry) {
        $data = [
            "description" => $this->description,
            "type" => $registry->getType($this->type),
        ];

        if($this->name !== null) {
            $data["name"] = $this->name;
        }

        if($this->defaultValue !== null) {
            $data["defaultValue"] = $this->defaultValue;
        }

        return $data;
    }
}
