<?php

declare(strict_types=1);

namespace MageQL;

use Exception;

use GraphQL\Error\ClientAware;

class SessionFailedException extends Exception implements ClientAware {
    public function __construct(Exception $e) {
        parent::__construct("Session failed to reinitialize", 0, $e);
    }

    public function isClientSafe() {
        return true;
    }

    public function getCategory() {
        return "internal";
    }
}

