<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

use MageQL\Type\AbstractBuilder;
use MageQL\Registry;

class MageQL_Core_Model_Route extends Mage_Core_Model_Abstract {
    /**
     * @param mixed $src
     * @return Mage_Core_Model_Url_Rewrite|Mage_Cms_Model_Page|null
     */
    public static function resolve($src, array $args, MageQL_Core_Model_Context $ctx, ResolveInfo $info) {
        $store = $ctx->getStore();
        $rewrite = Mage::getModel("core/url_rewrite")
            ->setStoreId($store->getId())
            ->loadByRequestPath($args["path"]);

        if($rewrite->getId()) {
            return $rewrite;
        }

        // We also try to load a CMS page if we cannot find anything in the URL rewrite
        $page = Mage::getModel("cms/page");

        $page->setStoreId($ctx->getStore()->getId());
        $page->load($args["path"], "identifier");

        if($page->getId() && $page->getIsActive()) {
            return $page;
        }

        return null;
    }

    /**
     * @param Mage_Core_Model_Url_Rewrite|Mage_Cms_Model_Page $rewrite
     */
    public static function typeResolver($rewrite): string {
        if($rewrite->getUrlRewriteId()) {
            $isRedirect = stripos($rewrite->getOptions() ?: "", "R") !== false;

            if($isRedirect) {
                return "RouteRedirect";
            }

            // We have to check if it is a product first, since it
            // might be a product inside of a category
            if($rewrite->getProductId()) {
                return "RouteProduct";
            }

            if($rewrite->getCategoryId()) {
                return "RouteCategory";
            }
        }
        else if($rewrite->getPageId()) {
            return "RouteCmsPage";
        }

        throw new Exception("Unknown route type");
    }
}
