<?php

declare(strict_types=1);

class MageQL_Core_Model_Context {
    /**
     * @var Mage_Core_Model_Store
     */
    protected $store;
    /**
     * @var Mage_Core_Model_Session_Abstract
     */
    protected $session;

    public function __construct(array $params = []) {
        $this->store   = $params["store"];
        $this->session = $params["session"];
    }

    public function getStore(): Mage_Core_Model_Store {
        return $this->store;
    }

    /**
     * @return mixed
     */
    public function getConfig(string $path) {
        return $this->store->getConfig($path);
    }

    public function getDefaultCountry(): string {
        // Always set
        return (string)$this->store->getConfig(Mage_Core_Helper_Data::XML_PATH_DEFAULT_COUNTRY);
    }

    public function stripBaseUrl(string $url): string {
        if( ! $url) {
            return $url;
        }

        $baseUrl = $this->store->getBaseUrl(Mage_Core_Model_Store::URL_TYPE_LINK, true);

        if(strpos($url, $baseUrl) === 0) {
            return "/".substr($url, strlen($baseUrl));
        }

        return $url;
    }
}
