<?php

declare(strict_types=1);

/**
 * Added methods for querying fields and attributes by set.
 *
 * @template AttrData of array{
 *   code:string,
 *   backend_type:string,
 *   input:string,
 *   label:string,
 *   required:bool,
 *   not_system:bool,
 *   attribute_set:Array<string>,
 *   attribute_set_type:Array<string>
 * }
 *
 * @template-extends MageQL_Core_Model_Attributes_Abstract<AttrData>
 */
abstract class MageQL_Core_Model_Attributes_Base extends MageQL_Core_Model_Attributes_Abstract {
    public function getSystemAttributes(): array {
        $attrs = [];

        foreach($this->getAttributes() as $field => $a) {
            if( ! $a["not_system"]) {
                $attrs[$field] = $a;
            }
        }

        return $attrs;
    }

    public function getSetAttributes(string $attributeSetType): array {
        $attrs = [];

        foreach($this->getAttributes() as $field => $a) {
            if( ! $a["not_system"] || in_array($attributeSetType, $a["attribute_set_type"])) {
                $attrs[$field] = $a;
            }
        }

        return $attrs;
    }
}
