<?php

declare(strict_types=1);

namespace MageQL\Type;

use GraphQL\Type\Definition\InterfaceType;
use MageQL\Registry;

class InterfaceBuilder extends AbstractBuilder {
    protected $resolveType;

    public function setResolveType(callable $resolveType): self {
        $this->resolveType = $resolveType;

        return $this;
    }

    public function getResolveType(): ?callable {
        return $this->resolveType;
    }

    public function createInstance(Registry $registry) {
        $data = [
            "description" => $this->description,
            "resolveType" => $this->resolveType,
            "fields" => function() use($registry) {
                return $registry->getFields($this->name);
            },
        ];

        if($this->name !== null) {
            $data["name"] = $this->name;
        }

        return new InterfaceType($data);
    }
}
