<?php

declare(strict_types=1);

namespace MageQL\Type;

use MageQL\Registry;

class InputFieldBuilder extends ArgumentBuilder {
    public function createInstance(Registry $registry) {
        $data = [
            "description" => $this->description,
            "type" => $registry->getType($this->type),
        ];

        if($this->name !== null) {
            $data["name"] = $this->name;
        }

        if($this->defaultValue !== null) {
            $data["defaultValue"] = $this->defaultValue;
        }

        return $data;
    }
}
