<?php

declare(strict_types=1);

namespace MageQL;

use GraphQL\Type\Definition\ResolveInfo;

abstract class AbstractResolver {
    abstract public function resolve($source, array $args, ContextInterface $context, ResolveInfo $info);

    public function __invoke($source, array $args, $context, ResolveInfo $info) {
        return $this->resolve($source, $args, $context, $info);
    }
}
