<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

class MageQL_Core_Model_Customer_Result {
    protected $type;
    protected $customer;

    public static function resolveResult(MageQL_Core_Model_Customer_Result $src): string {
        return $src->getType();
    }

    public static function resolveCustomer(MageQL_Core_Model_Customer_Result $src): ?Mage_Customer_Model_Customer {
        return $src->getCustomer();
    }

    public function __construct(string $type, Mage_Customer_Model_Customer $customer = null) {
        $this->type = $type;
        $this->customer = $customer;
    }

    public function getType(): string {
        return $this->type;
    }

    public function getCustomer(): ?Mage_Customer_Model_Customer {
        return $this->customer;
    }
}
