<?php

declare(strict_types=1);

class MageQL_Core_Model_Context {
    protected $store;
    protected $session;

    public function __construct(array $params = []) {
        $this->store   = $params["store"];
        $this->session = $params["session"];
    }

    public function getStore(): Mage_Core_Model_Store {
        return $this->store;
    }

    public function getConfig($path) {
        return $this->store->getConfig($path);
    }

    public function getDefaultCountry() {
        return $this->store->getConfig(Mage_Core_Model_Locale::XML_PATH_DEFAULT_COUNTRY);
    }

    public function stripBaseUrl($url) {
        if( ! $url) {
            return $url;
        }

        $baseUrl = $this->store->getBaseUrl(Mage_Core_Model_Store::URL_TYPE_LINK, true);

        if(strpos($url, $baseUrl) === 0) {
            return "/".substr($url, strlen($baseUrl));
        }

        return $url;
    }
}
