<?php

declare(strict_types=1);

namespace MageQL\Type;

use GraphQL\Type\Definition\ObjectType;
use MageQL\Registry;

class ObjectBuilder extends AbstractBuilder {
    protected $interfaces = [];
    protected $resolveField = null;

    public function setInterfaces(array $interfaces): self {
        $this->interfaces = $interfaces;

        return $this;
    }

    public function getInterfaces(): array {
        return $this->interfaces;
    }

    public function getResolveFields(): ?callable {
        return $this->resolveField;
    }

    public function setResolveField(callable $resolver): self {
        $this->resolveField = $resolver;

        return $this;
    }

    public function createInstance(Registry $registry) {
        // TODO: isTypeOf
        return new ObjectType([
            "name" => $this->name,
            "description" => $this->description,
            "resolveField" => $this->resolveField,
            "interfaces" => function () use($registry) {
                $interfaces = [];

                foreach($this->interfaces as $name) {
                    $interfaces[] = $registry->getType($name);
                }

                return $interfaces;
            },
            "fields" => function() use($registry) {
                return $registry->getFields($this->name);
            },
        ]);
    }
}
