<?php

declare(strict_types=1);

namespace MageQL\Type;

use GraphQL\Type\Definition\InputObjectType;
use MageQL\Registry;

class InputObjectBuilder extends ObjectBuilder {
    public function createInstance(Registry $registry) {
        $data = [
            "description" => $this->description,
            "interfaces" => function () use($registry) {
                $interfaces = [];

                foreach($this->interfaces as $name) {
                    $interfaces[] = $registry->getType($name);
                }

                return $interfaces;
            },
            "fields" => function() use($registry) {
                return $registry->getFields($this->name);
            },
        ];

        if($this->name !== null) {
            $data["name"] = $this->name;
        }

        return new InputObjectType($data);
    }
}
