<?php

declare(strict_types=1);

namespace MageQL\Type;

use MageQL\Registry;

class FieldBuilder extends TypedBuilder {
    protected $resolver = null;
    protected $arguments = [];
    protected $deprecationReason = null;

    // TODO: Rework parameters
    public function __construct(array $params = []) {
        if(array_key_exists("resolver", $params)) {
            $this->resolver = $params["resolver"];
        }

        parent::__construct($params);
    }

    public function setResolver($resolver): self {
        $this->resolver = $resolver;

        return $this;
    }

    public function getResolver() {
        return $this->resolver;
    }

    /**
     * Deprecates this field with a reason.
     */
    public function setDeprecated(string $reason): self {
        $this->deprecationReason = $reason;

        return $this;
    }

    public function addArgument(string $name, ArgumentBuilder $arg): self {
        $this->arguments[$name] = $arg;

        return $this;
    }

    public function createInstance(Registry $registry) {
        $data = [
            "type" => $registry->getType($this->type),
            "args" => array_map(function($arg) use($registry) {
                return $arg->createInstance($registry);
            }, $this->arguments),
            "resolve" => $this->resolver,
            "description" => $this->description,
            "isDeprecated" => (boolean)$this->deprecationReason,
            "deprecationReason" => $this->deprecationReason,
        ];

        if($this->name !== null) {
            $data["name"] = $this->name;
        }

        return $data;
    }
}
