<?php

declare(strict_types=1);

namespace MageQL\Type;

use MageQL\Registry;
use GraphQL\Type\Definition\EnumType;

class EnumBuilder extends AbstractBuilder {
    protected $values;

    public function __construct(array $params = []) {
        if(array_key_exists("values", $params)) {
            $this->values = $params["values"];
        }

        parent::__construct($params);
    }

    public function setValues(array $values): self {
        $this->values = $values;

        return $this;
    }

    public function getValues(array $values): self {
        return $this->values;
    }

    public function createInstance(Registry $registry) {
        return new EnumType([
            "name" => $this->name,
            "description" => $this->description,
            "values" => $this->values,
        ]);
    }
}
