<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

class MageQL_Core_Model_Store extends Mage_Core_Model_Abstract {
    const CONFIG_DESIGN_TITLE_PREFIX = "design/head/title_prefix";
    const CONFIG_DESIGN_TITLE_SUFFIX = "design/head/title_suffix";
    const CONFIG_DESIGN_DEFAULT_TITLE = "design/head/default_title";
    const CONFIG_DESIGN_DEFAULT_DESCRIPTION =  "design/head/default_description";

    public static function resolveCurrencyCodes(Mage_Core_Model_Store $src): array {
        return $src->getAvailableCurrencyCodes();
    }

    public static function resolveCountries(Mage_Core_Model_Store $src): array {
        $collection = Mage::getModel("directory/country")->getCollection();

        $collection->loadByStore($src);

        return $collection->getItems();
    }

    public static function resolveDefaultCountry(Mage_Core_Model_Store $src): Mage_Directory_Model_Country {
        $code = $src->getConfig(Mage_Core_Model_Locale::XML_PATH_DEFAULT_COUNTRY);
        $model = Mage::getModel("directory/country");

        $model->loadByCode($code);

        return $model;
    }

    public static function resolveDefaultDescription(Mage_Core_Model_Store $src): ?string {
        return $src->getConfig(self::CONFIG_DESIGN_DEFAULT_DESCRIPTION) ?: null;
    }

    public static function resolveDefaultTitle(Mage_Core_Model_Store $src): ?string {
        return $src->getConfig(self::CONFIG_DESIGN_DEFAULT_TITLE) ?: null;
    }

    public static function resolveLocale(Mage_Core_Model_Store $src): string {
        return $src->getConfig(Mage_Core_Model_Locale::XML_PATH_DEFAULT_LOCALE);
    }

    public static function resolveTitlePrefix(Mage_Core_Model_Store $src): ?string {
        return $src->getConfig(self::CONFIG_DESIGN_TITLE_PREFIX) ?: null;
    }

    public static function resolveTitleSuffix(Mage_Core_Model_Store $src): ?string {
        return $src->getConfig(self::CONFIG_DESIGN_TITLE_SUFFIX) ?: null;
    }
}
