<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

class MageQL_Core_Model_Customer extends Mage_Core_Model_Abstract {
    public static function resolveCustomer($src, array $args, $ctx, ResolveInfo $info) {
        $session = Mage::getSingleton("customer/session");

        if($session->isLoggedIn()) {
            return $session->getCustomer();
        }

        return null;
    }

    public static function resolveCreatedAt(Mage_Customer_Model_Customer $src) {
        return gmdate("Y-m-d\TH:i:s\Z", strtotime($src->getCreatedAt()));
    }

    public static function mutateLogin($src, array $args, $ctx, ResolveInfo $info) {
        $email = $args["email"];
        $password = $args["password"];
        try {
            // TODO: Should these be a part of the context?
            $session = Mage::getSingleton("customer/session");
            // TODO: Attributes?
            $customer = Mage::getModel("customer/customer")
                ->setStore($ctx->getStore())
                ->loadByEmail($email);

            $session->login($email, $password);
            $session->setCustomerAsLoggedIn($customer);
            $customer->setSession($session->getSessionId());

            return $customer;
        }
        catch(Mage_Core_Exception $e) {
            if($e->getMessage() === Mage::helper("customer")->__("Invalid login or password.")) {
                return "invalidEmailOrPassword";
            }

            if($e->getMessage() === Mage::helper("customer")->__("This account is not confirmed.")) {
                return "notConfirmed";
            }

            throw $e;
        }
    }

    public static function mutateLogout() {
        $session = Mage::getSingleton("customer/session");

        if($session->isLoggedIn()) {
            $session->logout();

            return true;
        }

        return false;
    }
}
